<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <div class="container mx-auto px-4 py-6">
         <?php $__env->slot('header', null, []); ?> 
            <?php echo $__env->make('finances.navigation', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
         <?php $__env->endSlot(); ?>

        <a href="<?php echo e(route('finances.create')); ?>" class="btn btn-primary mb-3">+ Nouveau</a>
        <h4 style="float:right;width:fit-content;color:#333"><?php echo e($title); ?></h4>
        <hr>

        <?php if(session('success')): ?>
            <div class="alert alert-success">
                <?php echo e(session('success')); ?>

            </div>
            <hr>
        <?php endif; ?>

        <div style="
            display: flex;
            justify-content: space-between;
            align-items: center;
            align-content: center;
            margin-bottom:15px !important

        ">

            <form method="GET" action="<?php echo e(route('finances.index')); ?>" class="mb-4" style="
                margin: 0px !important;
            ">
                <?php echo csrf_field(); ?>
                <input type="text" name="search" placeholder="Rechercher..." class="border px-4 py-2 w-1/3" value="<?php echo e(request('search')); ?>" style="width:270px">
                <button type="submit" class="bg-blue-500 text-white px-4 py-2">Rechercher</button>
            </form>

            <div class="caption">
                 
            </div>
        </div>

        <form id="bulk-delete-form" action="<?php echo e(route('finances.bulk-delete')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <?php echo method_field('DELETE'); ?>
            <table class="table-auto w-full border-collapse border border-gray-300 shadow">
                <thead>
                    <tr class="bg-gray-200">
                        <th class="border px-4 py-2">#</th>
                        <th class="border text-center" width="30"><input type="checkbox" id="check-all"></th>
                        <th class="border px-4 py-2">Type</th>
                        <th class="border px-4 py-2">Montant (XAF)</th>
                        <th class="border px-4 py-2">Source</th>
                        <th class="border px-4 py-2">Réservation</th>
                        <th class="border px-4 py-2">Valide</th>
                        <th class="border px-4 py-2">Sens</th>
                        <th class="border px-4 py-2">Date</th>
                        <th class="border px-4 py-2">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $i = 1; ?>
                    <?php $__currentLoopData = $finances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $finance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td class="border px-4 py-2"><?php echo e($i++); ?></td>
                            <td class="border text-center" width="30">
                                <input type="checkbox" name="ids[]" value="<?php echo e($finance->id); ?>" class="checkbox">
                            </td>
                            <td class="border px-4 py-2"><?php echo e(ucfirst(str_replace('_', ' ', $finance->type))); ?></td>
                            <td class="border px-4 py-2"><?php echo e(number_format($finance->montant, 0, ',', ' ')); ?></td>
                            <td class="border px-4 py-2"><?php echo e($finance->source ?? 'N/A'); ?></td>
                            <td class="border px-4 py-2">
                                <?php if($finance->reservation): ?>
                                    <a href="<?php echo e(route('reservations.show', $finance->reservation->id)); ?>" class="text-blue-500">
                                        <?php echo e($finance->reservation->code); ?>

                                    </a>
                                <?php else: ?>
                                    <span class="text-gray-400">Non liée</span>
                                <?php endif; ?>
                            </td>
                            <td class="border px-4 py-2">
                                <span class="badge <?php echo e($finance->valide ? 'bg-green-500' : 'bg-red-500'); ?> text-white px-2 py-1 rounded text-xs">
                                    <?php echo e($finance->valide ? 'Oui' : 'Non'); ?>

                                </span>
                            </td>
                            <td class="border px-4 py-2">
                                <span class="badge <?php echo e($finance->sens=='sortie' ? 'bg-red-500' : 'bg-green-500'); ?> text-white px-2 py-1 rounded text-xs">
                                    <?php echo e($finance->sens); ?>

                                </span>
                            </td>
                            <td class="border px-4 py-2">
                                <?php echo e(\Carbon\Carbon::parse($finance->date_operation)->format('d/m/Y H:i')); ?>

                            </td>
                            <td class="border px-4 py-2">
                                <?php if($finance->valide): ?>
                                <?php else: ?>
                                <a href="<?php echo e(route('finances.edit', $finance->id)); ?>" class="text-info"><span class="fa fa-pencil-alt"></span> edit</a> |
                                <?php endif; ?>
                                <a style="cursor:pointer" class="text-danger delete-btn" ><span class="fa fa-file"></span> Voir.</a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

            <button id="bulk-delete-btn" type="button"></button>
        </form>
        <!-- Pagination -->
        <div class="mt-4">
            <?php echo e($finances->links()); ?> <!-- Cela génère les liens de pagination -->
        </div>

    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const deleteButtons = document.querySelectorAll('.delete-btn');

        deleteButtons.forEach(button => {
            button.addEventListener('click', function () {
                const financeId = this.getAttribute('data-id');

                Swal.fire({
                    title: 'Êtes-vous sûr ?',
                    text: "Cette action est irréversible !",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Oui, supprimer',
                    cancelButtonText: 'Annuler'
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.getElementById('delete-form-' + financeId).submit();
                    }
                });
            });
        });
    });
</script>

<script>
    document.getElementById('check-all').addEventListener('change', function () {
        const checkboxes = document.querySelectorAll('.checkbox');
        checkboxes.forEach(cb => cb.checked = this.checked);
    });

    document.getElementById('bulk-delete-btn').addEventListener('click', function () {
        const form = document.getElementById('bulk-delete-form');
        const selected = form.querySelectorAll('.checkbox:checked');

        if (selected.length === 0) {
            Swal.fire('Aucun élément sélectionné', 'Veuillez sélectionner au moins un utilisateur.', 'info');
            return;
        }

        Swal.fire({
            title: 'Confirmer la suppression ?',
            text: "Les utilisateurs sélectionnés seront supprimés.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Oui, supprimer',
            cancelButtonText: 'Annuler',
            confirmButtonColor: '#d33'
        }).then((result) => {
            if (result.isConfirmed) {
                form.submit();
            }
        });
    });
</script>


<?php /**PATH C:\Users\EASYTECH AFRICA\Documents\DMC\EVOX-BACK\resources\views/finances/index.blade.php ENDPATH**/ ?>