<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <div class="container mx-auto px-4 py-6">
         <?php $__env->slot('header', null, []); ?> 
            <?php echo $__env->make('cars.navigation', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
         <?php $__env->endSlot(); ?>


        <a href="<?php echo e(route('gammes.create')); ?>" class="btn btn-primary mb-3">+ Nouvelle gamme</a>
        <h4 style="float:right;width:fit-content;color:#333">Liste des gammes de véhicules</h4>
        <hr>

        <?php if(session('success')): ?>
            <div class="alert alert-success mt-3 mb-4">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <div class="flex justify-between items-center mb-4">
            <form method="GET" action="<?php echo e(route('gammes.index')); ?>">
                <input type="text" name="search" placeholder="Rechercher..." class="border px-4 py-2"
                       value="<?php echo e(request('search')); ?>">
                <button type="submit" class="bg-blue-500 text-white px-4 py-2">Rechercher</button>
            </form>

            <a onclick="document.getElementById('bulk-delete-btn').click();"
               class="btn btn-outline-secondary"
               style="background:transparent; border:1px solid #333; color:#333;">
                <span class="fa fa-trash"></span> Supprimer
            </a>
        </div>
        <?php $__currentLoopData = $gammes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gamme): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <form id="delete-form-<?php echo e($gamme->id); ?>" action="<?php echo e(route('gammes.destroy', $gamme->id)); ?>" method="POST" style="display: none;">
            <?php echo csrf_field(); ?>
            <?php echo method_field('DELETE'); ?>
        </form>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <form id="bulk-delete-form" action="<?php echo e(route('gammes.bulk-delete')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <?php echo method_field('DELETE'); ?>
            <table class="table-auto w-full border-collapse border border-gray-300 shadow">
                <thead>
                    <tr class="bg-gray-200">
                        <th class="border px-4 py-2">#</th>
                        <th class="border text-center" width="30"><input type="checkbox" id="check-all"></th>
                        <th class="border px-4 py-2">Nom</th>
                        <th class="border px-4 py-2">Tarif (xaf)</th>
                        <th class="border px-4 py-2">Description</th>
                        <th class="border px-4 py-2">Créé le</th>
                        <th class="border px-4 py-2">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $i = 1; ?>
                    <?php $__currentLoopData = $gammes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gamme): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td class="border px-4 py-2"><?php echo e($i++); ?></td>
                            <td class="border text-center">
                                <input type="checkbox" name="ids[]" value="<?php echo e($gamme->id); ?>" class="checkbox">
                            </td>
                            <td class="border px-4 py-2"><?php echo e($gamme->libelle); ?></td>
                            <td class="border px-4 py-2"><?php echo e(number_format($gamme->tarif, 0, ',', ' ')); ?></td>
                            <td class="border px-4 py-2"><?php echo e(Str::limit($gamme->description, 60)); ?></td>
                            <td class="border px-4 py-2"><?php echo e($gamme->created_at); ?></td>
                            <td class="border px-4 py-2">
                                <a href="<?php echo e(route('gammes.edit', $gamme->id)); ?>" class="text-blue-600"><span class="fa fa-pencil-alt"></span> Modifier</a> |
                                <a href="#" class="text-red-600 delete-btn" data-id="<?php echo e($gamme->id); ?>"><span class="fa fa-trash"></span> Supprimer</a>
                                
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            <button id="bulk-delete-btn" type="button" style="display:none;"></button>
        </form>

        <div class="mt-4">
            <?php echo e($gammes->links()); ?>

        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Suppression individuelle
        document.querySelectorAll('.delete-btn').forEach(button => {
            button.addEventListener('click', function () {
                const id = this.dataset.id;
                Swal.fire({
                    title: 'Supprimer cette gamme ?',
                    text: "Cette action est irréversible.",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Oui, supprimer',
                    cancelButtonText: 'Annuler'
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.getElementById('delete-form-' + id).submit();
                    }
                });
            });
        });

        // Sélection tous les checkboxes
        document.getElementById('check-all').addEventListener('change', function () {
            document.querySelectorAll('.checkbox').forEach(cb => cb.checked = this.checked);
        });

        // Suppression en groupe
        document.getElementById('bulk-delete-btn').addEventListener('click', function () {
            const form = document.getElementById('bulk-delete-form');
            const selected = form.querySelectorAll('.checkbox:checked');

            if (selected.length === 0) {
                Swal.fire('Aucun élément sélectionné', 'Veuillez sélectionner au moins une gamme.', 'info');
                return;
            }

            Swal.fire({
                title: 'Confirmer la suppression ?',
                text: "Les gammes sélectionnées seront supprimées.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Oui, supprimer',
                cancelButtonText: 'Annuler',
                confirmButtonColor: '#d33'
            }).then((result) => {
                if (result.isConfirmed) {
                    form.submit();
                }
            });
        });
    });
</script>
<?php /**PATH C:\Users\EASYTECH AFRICA\Documents\DMC\EVOX-BACK\resources\views/cars/gammes/index.blade.php ENDPATH**/ ?>