<style>
    nav.navbar {
        background: transparent;
    }
    .navbar .logo {
      font-size: 1.5rem;
      font-weight: bold;
      letter-spacing: 1px;
      color: #fff;
    }

    .navbar ul {
      list-style: none;
      display: flex;
      gap: 2rem;
      margin: 0;
      padding: 0;
    }

    .navbar ul li {
      position: relative;
    }

    .navbar ul li a {
      text-decoration: none;
      color: #fff;
      font-weight: 500;
      transition: color 0.3s ease;
    }

    .navbar ul li a::after {
      content: "";
      display: block;
      height: 2px;
      width: 0;
      background: #00ffd5;
      transition: width 0.3s;
      position: absolute;
      bottom: -5px;
      left: 0;
    }

    .navbar ul li a:hover::after {
      width: 100%;
    }

    .navbar ul li a:hover {
      color: #00ffd5;
    }
</style>

<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <nav class="navbar">
            <div class="logo">Tableau de bord</div>
        </nav>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class=" mx-auto sm:px-6 lg:px-8">
            <div class="">
                
                <h2><b>Vehicules</b></h2><hr>

                <div class="row mb-4">
                    <div class="col-md-3">
                        <div class="card text-white bg-primary">
                            <div class="card-body">
                                <h5>Total véhicules</h5>
                                <h3><?php echo e($totalCars); ?></h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card text-white bg-success">
                            <div class="card-body">
                                <h5>Actifs</h5>
                                <h3><?php echo e($carsActifs); ?></h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card text-white bg-danger">
                            <div class="card-body">
                                <h5>Inactifs</h5>
                                <h3><?php echo e($carsInactifs); ?></h3>
                            </div>
                        </div>
                    </div>
                </div>
                <table class="table-auto w-full border-collapse border border-gray-300 shadow mb-4">
                    <thead>
                    <tr class="bg-gray-200">
                            <th class="border px-4 py-2">#</th>
                            <th class="border px-4 py-2">Marque</th>
                            <th class="border px-4 py-2">Modèle</th>
                            <th class="border px-4 py-2">Immatriculation</th>
                            <th class="border px-4 py-2">Carburant</th>
                            <th class="border px-4 py-2">Transmission</th>
                            <th class="border px-4 py-2">Proprietaire</th>
                            <th class="border px-4 py-2">Statut</th>
                            <th class="border px-4 py-2">Gamme</th>
                            <th class="border px-4 py-2">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php $i = 1; ?>
                        <?php $__currentLoopData = $cars; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $car): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="border px-4 py-2"><?php echo e($i++); ?></td>
                                
                                <td class="border px-4 py-2"><?php echo e($car->marque); ?></td>
                                <td class="border px-4 py-2"><?php echo e($car->modele); ?></td>
                                <td class="border px-4 py-2"><?php echo e($car->immatriculation); ?></td>
                                <td class="border px-4 py-2"><?php echo e(ucfirst($car->carburant) ?? 'Non défini'); ?></td>
                                <td class="border px-4 py-2"><?php echo e(ucfirst($car->transmission) ?? 'Non défini'); ?></td>
                                <td class="border px-4 py-2">
                                    <?php echo e($car->proprietaire->name ?? 'Non attribué'); ?>

                                </td>
                                <td class="border px-4 py-2">
                                    <span class="badge <?php echo e($car->statut == 'disponible' ? 'bg-success' : 'bg-warning'); ?>">
                                        <?php echo e(ucfirst($car->statut)); ?>

                                    </span>
                                </td>
                                <td class="border px-4 py-2"><?php echo e($car->gamme->nom ?? 'Aucune'); ?></td>
                                <td class="border px-4 py-2">
                                    
                                    
                                    
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                    </tbody>
                </table>
                <h2><b>Réservations</b></h2><hr>
                <div class="row mb-4">
                    <div class="col-md-3">
                        <div class="card text-white bg-primary shadow">
                            <div class="card-body">
                                <h5 class="card-title">📦 Réservations totales</h5>
                                <h3><?php echo e($totalReservations); ?></h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card text-white bg-success shadow">
                            <div class="card-body">
                                <h5 class="card-title">🟢 Desservies</h5>
                                <h3><?php echo e($totalDesservies); ?></h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card text-white bg-danger shadow">
                            <div class="card-body">
                                <h5 class="card-title">🔴 Non desservies</h5>
                                <h3><?php echo e($totalNonDesservies); ?></h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card text-white bg-warning ">
                            <div class="card-body">
                                <h5 class="card-title">💰 Revenu total</h5>
                                <h3><?php echo e(number_format($revenuTotal, 0, ',', ' ')); ?> FCFA</h3>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="caption mb-4" style="overflow-x:scroll">
                    <table class="table-auto w-full border-collapse border border-gray-300 shadow" style="width: 2350px;">
                        <thead class="bg-gray-200">
                            <tr>
                                <th class="border px-4 py-2">#</th>
                                
                                <th class="border px-4 py-2">Initié le</th>
                                <th class="border px-4 py-2">Code</th>
                                <th class="border px-4 py-2">Départ</th>
                                <th class="border px-4 py-2">Destination</th>
                                <th class="border px-4 py-2">Date depart</th>
                                <th class="border px-4 py-2">Heure</th>
                                <th class="border px-4 py-2">Places</th>
                                <th class="border px-4 py-2">Client</th>
                                <th class="border px-4 py-2">Téléphone</th>
                                <th class="border px-4 py-2">Chauffeur</th>
                                <th class="border px-4 py-2">Solde(xaf)</th>
                                <th class="border px-4 py-2">Gamme</th>
                                <th class="border px-4 py-2">Statut</th>
                                <th class="border px-4 py-2">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $i = 1; ?>
                            <?php $__currentLoopData = $reservations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $res): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr >
                                    <td class="border px-4 py-2"><?php echo e($i++); ?></td>
                                    
                                    <td class="border px-4 py-2"><?php echo e(\Carbon\Carbon::parse($res->created_at)->format('d/m/Y')); ?></td>
                                    <td class="border px-4 py-2"><?php echo e($res->code); ?></td>
                                    <td class="border px-4 py-2"><?php echo e($res->depart); ?></td>
                                    <td class="border px-4 py-2"><?php echo e($res->destination); ?></td>
                                    <td class="border px-4 py-2"><?php echo e($res->date_depart); ?></td>
                                    <td class="border px-4 py-2"><?php echo e($res->heure_depart); ?></td>
                                    <td class="border px-4 py-2"><?php echo e($res->place); ?></td>
                                    <td class="border px-4 py-2"><a href="<?php echo e(route('users.edit', $res->user->id)); ?>" class="text-primary"><?php echo e($res->user->name); ?></a></td>
                                    <td class="border px-4 py-2"><?php echo e($res->telephone); ?></td>
                                    <td class="border px-4 py-2">
                                        <?php
                                        if ($res->chauffeur) {
                                        ?> 
                                        <a href="<?php echo e(route('users.edit', $res->chauffeur->id)); ?>" class="text-primary"><?php echo e($res->chauffeur->name ?? ''); ?></a>
                                        <?php
                                        }
                                        ?>
                                    </td>
                                    <td class="border px-4 py-2"><?php echo e($res->solde); ?></td>
                                    <td class="border px-4 py-2"><?php echo e($res->gamme->nom ?? ''); ?></td>
                                    <td class="border px-4 py-2">
                                        <span class="badge <?php echo e($res->statut == 1 ? 'bg-success' : 'bg-danger'); ?>">
                                            <?php echo e($res->statut == 1 ? 'Confirmée' : 'En attente'); ?>

                                        </span>
                                    </td>
                                    <td class="border px-4 py-2">
                                        
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
                
                  <h2><b>Utilisateurs</b></h2><hr>
                <div class="row mb-4">
                  <div class="col-md-3">
                      <div class="card text-white bg-primary shadow">
                          <div class="card-body">
                              <h5 class="card-title">📦Total utilisateurs</h5>
                              <h3><?php echo e($totalUsers); ?></h3>
                          </div>
                      </div>
                  </div>
                  <div class="col-md-3">
                      <div class="card text-white bg-info shadow">
                          <div class="card-body">
                              <h5 class="card-title">📦Clients</h5>
                              <h3><?php echo e($totalClients); ?></h3>
                          </div>
                      </div>
                  </div>
                  <div class="col-md-3">
                      <div class="card text-white bg-success shadow">
                          <div class="card-body">
                              <h5 class="card-title">📦Chauffeurs</h5>
                              <h3><?php echo e($totalChauffeurs); ?></h3>
                          </div>
                      </div>
                  </div>
                  <div class="col-md-3">
                      <div class="card text-white bg-warning shadow">
                          <div class="card-body">
                              <h5>Actifs / Inactifs</h5>
                              <h3><?php echo e($actifs); ?> / <?php echo e($inactifs); ?></h3>
                          </div>
                      </div>
                  </div>
                </div>
              </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\Users\EASYTECH AFRICA\Documents\DMC\EVOX-BACK\resources\views/dashboard.blade.php ENDPATH**/ ?>