<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <div class="container mx-auto px-4 py-6">
         <?php $__env->slot('header', null, []); ?> 
            <?php echo $__env->make('reservations.navigation', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?> <!-- Crée ce fichier si nécessaire -->
         <?php $__env->endSlot(); ?>

        <a href="<?php echo e(route('reservations.create')); ?>" class="btn btn-primary ">+ Nouvelle réservation</a>
        <h4 style="float:right;width:fit-content;color:#333">Statistique de reservation</h4>
        <hr>
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card text-white bg-primary shadow">
                    <div class="card-body">
                        <h5 class="card-title">📦 Réservations totales</h5>
                        <h3><?php echo e($totalReservations); ?></h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card text-white bg-success shadow">
                    <div class="card-body">
                        <h5 class="card-title">🟢 Desservies</h5>
                        <h3><?php echo e($totalDesservies); ?></h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card text-white bg-danger shadow">
                    <div class="card-body">
                        <h5 class="card-title">🔴 Non desservies</h5>
                        <h3><?php echo e($totalNonDesservies); ?></h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card text-white bg-warning ">
                    <div class="card-body">
                        <h5 class="card-title">💰 Revenu total</h5>
                        <h3><?php echo e(number_format($revenuTotal, 0, ',', ' ')); ?> FCFA</h3>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-4 mb-4">
                <div class="card shadow mb-2" >
                    <div class="card-header"><h4>📅 Réservations par mois</h4></div>
                    <div class="card-body">
                        <canvas id="reservationsMois"></canvas>
                    </div>
                </div>
                
            </div>
            <div class="col-lg-4">
                <div class="card shadow">
                    <div class="card-header"> <h4>💰 Revenus mensuels</h4></div>
                    <div class="card-body">
                        <canvas id="revenusChart"></canvas>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="card shadow">
                    <div class="card-header"> <h4>🟢 Réservations desservies vs non desservies</h4></div>
                    <div class="card-body">
                        <canvas id="desserviChart"></canvas>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-3">
                <div class="card shadow" style="height: 388px">
                    <div class="card-header"> <h4>📊 Répartition par statut</h4></div>
                    <div class="card-body">
                        <canvas id="statutChart"></canvas>
                    </div>
                </div>
            </div>

            

            <div class="col-lg-3">
                <div class="card shadow" style="height: 388px">
                    <div class="card-header"> <h4>🚘 Répartition par gamme</h4></div>
                    <div class="card-body">
                        <canvas id="gammeChart"></canvas>
                    </div>
                </div>
            </div>

        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    const reservationsMois = <?php echo json_encode($reservationsParMois, 15, 512) ?>;
    const labelsMois = reservationsMois.map(item => item.mois);
    const dataMois = reservationsMois.map(item => item.total);

    new Chart(document.getElementById('reservationsMois'), {
        type: 'line',
        data: {
            labels: labelsMois,
            datasets: [{
                label: 'Nombre de réservations',
                data: dataMois,
                borderColor: 'blue',
                fill: false
            }]
        }
    });

    const statuts = <?php echo json_encode($reservationsParStatut, 15, 512) ?>;
    new Chart(document.getElementById('statutChart'), {
        type: 'pie',
        data: {
            labels: statuts.map(s => s.statut),
            datasets: [{
                data: statuts.map(s => s.total),
                backgroundColor: ['#f39c12', '#27ae60', '#c0392b']
            }]
        }
    });

    const revenus = <?php echo json_encode($revenusParMois, 15, 512) ?>;
    new Chart(document.getElementById('revenusChart'), {
        type: 'bar',
        data: {
            labels: revenus.map(r => r.mois),
            datasets: [{
                label: 'Revenus (FCFA)',
                data: revenus.map(r => r.revenus),
                backgroundColor: 'green'
            }]
        }
    });

    const gammes = <?php echo json_encode($gammes, 15, 512) ?>;
    new Chart(document.getElementById('gammeChart'), {
        type: 'doughnut',
        data: {
            labels: gammes.map(g => g.gamme_libelle),
            datasets: [{
                data: gammes.map(g => g.total),
                backgroundColor: ['#3498db', '#e74c3c', '#9b59b6', '#1abc9c']
            }]
        }
    });

    const desservis = <?php echo json_encode($desservis, 15, 512) ?>;

new Chart(document.getElementById('desserviChart'), {
    type: 'bar',
    data: {
        labels: desservis.map(d => d.statut_desservi),
        datasets: [{
            label: 'Nombre de réservations',
            data: desservis.map(d => d.total),
            backgroundColor: [ '#e74c3c','#2ecc71']
        }]
    },
    options: {
        responsive: true,
        plugins: {
            legend: {
                display: false
            },
            title: {
                display: true,
                text: 'Comparaison Desservi / Non desservi'
            }
        },
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});

</script>
<?php /**PATH C:\Users\EASYTECH AFRICA\Documents\DMC\EVOX-BACK\resources\views/reservations/stat.blade.php ENDPATH**/ ?>