<style>
    .form-control, .typeahead, .tt-query, .tt-hint, .select2-container--default .select2-selection--single .select2-search__field, .select2-container--default .select2-selection--single, .form-select {
        border: 1px solid #dee2e6;
        font-weight: 400;
        border-radius: 4px;
        height: 2.5rem !important;
    }
</style>
<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
           @include('parametres.navigation')
        </x-slot>


        <a href="{{ route('zone.index') }}" class="btn btn-danger mb-1">+ Liste</a>
        <h4 style="float:right;width:fit-content;color:#333">Editer zone</h4>
        <hr>


        <div class="content">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="p-3">
                <div class="row">
                    <div class="col-md-3">
                        <div class="card p-4">
                            <form action="{{ route('zone.update',$zone->id) }}" method="POST">
                                @csrf
                                @method('PUT')

                                <div class="mb-1">
                                    <label for="name" class="form-label">Nom de la zone</label>
                                    <input type="text" name="name" class="form-control" id="name" value="{{ old('name', $zone->name ?? '') }}" required>
                                </div>

                                <div class="mb-1">
                                    <label for="code" class="form-label">Code</label>
                                    <input type="text" name="code" class="form-control" id="code" value="{{ old('code', $zone->code ?? '') }}" required>
                                </div>

                                <div class="mb-1">
                                    <label for="description" class="form-label">Description</label>
                                    <textarea name="description" class="form-control" id="description" rows="3">{{ old('description', $zone->description ?? '') }}</textarea>
                                </div>
                                <div class="mb-1">
                                    <label for="description" class="form-label">Ville</label>
                                    <select name="ville_id" class="form-control" required>
                                        <option value="">-- Sélectionner --</option>
                                        @foreach($villes as $ville)
                                            <option value="{{ $ville->id }}" @if ($ville->id == $zone->ville->id)
                                                selected
                                            @endif>{{ $ville->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <button type="submit" class="btn btn-primary">
                                    {{ isset($zone) ? 'Mettre à jour' : 'Créer' }}
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
                
            </div>
                
        </div>
    </div>
</x-app-layout>

