<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
            @include('parametres.navigation')
        </x-slot>

        <a href="{{ route('ville.create') }}" class="btn btn-danger shadow" >+ Nouveau</a>
        <h4 style="float:right;width:fit-content;color:#333">Liste des villes</h4>
        <hr>
        
         <table class="table table-bordered table-striped" id="myTable">
            <thead class="table-dark">
                <tr>
                    <th>Code</th>
                    <th>Ville</th>
                     @if(Auth::user()->role === 'admin')
                        <th>Action</th>
                    @endif
                </tr>
            </thead>
            <tbody>
                @foreach($villes as $ville)
                    <tr>
                        <td>{{ $ville->code }}</td>
                        <td>{{ $ville->name }}</td>
                         @if(Auth::user()->role === 'admin')
                            <td>
                                <a href="{{ route('ville.edit', $ville->id) }}">✏️</a>
                                <button onclick="confirmDelete({{ $ville->id }})">🗑️</button>
                            </td>
                        @endif
                    </tr>
                @endforeach
            </tbody>
        </table>

    </div>

</x-app-layout>

    <!-- Modal -->
<div class="modal fade" id="createPrisonModal" tabindex="1" aria-labelledby="createPrisonModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-md"> <!-- Large modal -->
    <div class="modal-header" style="
                background: #000;color: #fff !important;
      ">
      <h5 class="modal-title" id="createPrisonModalLabel" >Veuillez choisir le type</h5>
      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" style="background: #fff"></button>
    </div>
    <div class="modal-content">
      <a href="{{ route('prisons.create', ['type' => 'cc']) }}" class="btn btn-default form-control shadow">Commissariat Central (CC)</a>
      <a href="{{ route('prisons.create', ['type' => 'cpa']) }}" class="btn btn-default form-control shadow">Commissariat de Police d'Arrondissement (CPA)</a>
      <a href="{{ route('prisons.create', ['type' => 'cpq']) }}" class="btn btn-default form-control shadow">Commissariat de Police de quartier (CPQ)</a>
      <a href="{{ route('prisons.create', ['type' => 'pa']) }}" class="btn btn-default form-control shadow">Poste avancé</a>
    </div>
  </div>
</div>

<script>
    function confirmDelete(userId) {
        Swal.fire({
            title: 'Êtes-vous sûr ?',
            text: "Cette action est irréversible.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Oui, supprimer',
            cancelButtonText: 'Annuler'
        }).then((result) => {
            if (result.isConfirmed) {
                document.getElementById('delete-form-' + userId).submit();
            }
        });
    }
</script>

<script>
    document.getElementById('check-all').addEventListener('change', function () {
        const checkboxes = document.querySelectorAll('.checkbox');
        checkboxes.forEach(cb => cb.checked = this.checked);
    });

    document.getElementById('bulk-delete-btn').addEventListener('click', function () {
        const form = document.getElementById('bulk-delete-form');
        const selected = form.querySelectorAll('.checkbox:checked');

        if (selected.length === 0) {
            Swal.fire('Aucun élément sélectionné', 'Veuillez sélectionner au moins un utilisateur.', 'info');
            return;
        }

        Swal.fire({
            title: 'Confirmer la suppression ?',
            text: "Les utilisateurs sélectionnés seront supprimés.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Oui, supprimer',
            cancelButtonText: 'Annuler',
            confirmButtonColor: '#d33'
        }).then((result) => {
            if (result.isConfirmed) {
                form.submit();
            }
        });
    });
</script>


<!-- Bootstrap JS avec Popper -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

