<style>
    .form-control, .typeahead, .tt-query, .tt-hint, .select2-container--default .select2-selection--single .select2-search__field, .select2-container--default .select2-selection--single, .form-select {
        border: 1px solid #dee2e6;
        font-weight: 400;
        border-radius: 4px;
        height: 2rem !important;
    }
</style>
<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
            @include('users.navigation')
        </x-slot>


        <a href="{{ route('users.index') }}" class="btn btn-primary mb-3">+ Liste</a>
        <h4 style="float:right;width:fit-content;color:#333">Nouvel utilisateur</h4>
        <hr>

        @if ($errors->any())
            <div class="alert alert-danger my-3">
                <ul class="list-disc pl-5">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <div class="container">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="p-3">
                <!-- resources/views/admin/users/create.blade.php -->
                 <div class="card shadow p-4">
                    <form action="{{ route('users.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf

                        <div class="row">
                            <div class="col-md-4">
                                <div class="mb-1">
                                    <label for="name" class="form-label">Nom complet</label>
                                    <input type="text" name="name" class="form-control" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <!-- Email -->
                                <div class="mb-1">
                                    <label for="email" class="form-label">Email</label>
                                    <input type="email" name="email" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <!-- Téléphone -->
                                <div class="mb-1">
                                    <label for="phone" class="form-label">Téléphone</label>
                                    <input type="text" name="phone_number" class="form-control" required>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <!-- Rôle -->
                                <div class="mb-1">
                                    <label for="role" class="form-label">Rôle</label>
                                    <select name="role" class="form-control" required>
                                        <option value="admin">Admin</option>
                                        <option value="cpa">CPA</option>
                                        <option value="cpq">CPQ</option>
                                        <option value="cp">CP</option>
                                        <option value="ct">CT</option>
                                        <option value="cc">CC</option>
                                        <option value="geolier">Geôlier</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <!-- Prison assignée -->
                                <div class="mb-1">
                                    <label for="assigned_prison_id" class="form-label">Prison assignée</label>
                                    <select name="assigned_prison_id" class="form-control">
                                        @foreach($prisons as $prison)
                                            <option value="{{ $prison->id }}">{{ $prison->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <!-- Photo -->
                                <div class="mb-1">
                                    <label for="photo" class="form-label">Photo</label>
                                    <input type="file" name="photo" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <!-- Mot de passe -->
                                <div class="mb-1">
                                    <label for="password" class="form-label">Mot de passe</label>
                                    <input type="password" name="password" class="form-control" required>
                                </div>
                            </div>

                        </div>
                        <!-- Nom -->
                        
                        <button type="submit" class="btn btn-primary">Enregistrer</button>
                    
                    </form>
                </div>

            </div>
                
        </div>
    </div>
</x-app-layout>

