<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
            @include('reservations.navigation') <!-- Crée ce fichier si nécessaire -->
        </x-slot>

        <a href="{{ route('reservations.create') }}" class="btn btn-primary ">+ Nouvelle réservation</a>
        <h4 style="float:right;width:fit-content;color:#333">{{$title}}</h4>
        <hr>

        @if (session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
            <hr>
        @endif

        <div class="flex justify-between items-center mb-4">
            <form method="GET" action="{{ route('reservations.index') }}" class="mb-4">
                @csrf
                <input type="text" name="search" placeholder="Rechercher..." class="border px-4 py-2" value="{{ request('search') }}" style="width:270px">
                <button type="submit" class="bg-blue-500 text-white px-4 py-2">Rechercher</button>
            </form>

            <div class="caption" style="width:fit-content">
                 @php
                    if($etat==1){
                @endphp
                    <a onclick="document.getElementById('bulk-delete-btn3').click();" class="btn btn-info" style="border:1px solid #333; color:#333;">
                        <span class="fa fa-check"></span> Desservir
                    </a>
                @php
                    }
                @endphp

                @php
                    if($etat==0){
                        @endphp
                        <a id="bulk-delete-btn1" class="btn btn-success" style="border:1px solid #333; color:#333;">
                            <span class="fa fa-arrow-right"></span> Affecter
                        </a>
                        <a onclick="document.getElementById('bulk-delete-btn').click();" class="btn btn-outline-secondary" style="border:1px solid #333; color:#333;">
                            <span class="fa fa-trash"></span> Supprimer
                        </a>
                        @php
                    }
                @endphp
            </div>

        </div>

        
        @foreach ($reservations as $res)
            <form id="delete-form-{{ $res->id }}" action="{{ route('reservations.destroy', $res->id) }}" method="POST" style="display: none;">
                @csrf
                @method('DELETE')
            </form>
        @endforeach

        <form id="bulk-delete-form" action="{{ route('reservations.bulk-delete') }}" method="POST" style="overflow-x:scroll;">
            @csrf
            @method('DELETE')

            <input type="hidden" value="0" name="action_group" id="action_group">
            <table class="table-auto w-full border-collapse border border-gray-300 shadow" style="width: 2350px;">
                <thead class="bg-gray-200">
                    <tr>
                        <th class="border px-4 py-2">#</th>
                        <th class="border text-center"><input type="checkbox" id="check-all"></th>
                        <th class="border px-4 py-2">Initié le</th>
                        <th class="border px-4 py-2">Code</th>
                        <th class="border px-4 py-2">Départ</th>
                        <th class="border px-4 py-2">Destination</th>
                        <th class="border px-4 py-2">Date depart</th>
                        <th class="border px-4 py-2">Heure</th>
                        <th class="border px-4 py-2">Places</th>
                        <th class="border px-4 py-2">Client</th>
                        <th class="border px-4 py-2">Téléphone</th>
                        <th class="border px-4 py-2">Chauffeur</th>
                        <th class="border px-4 py-2">Solde(xaf)</th>
                        <th class="border px-4 py-2">Gamme</th>
                        <th class="border px-4 py-2">Statut</th>
                        <th class="border px-4 py-2">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @php $i = 1; @endphp
                    @foreach ($reservations as $res)
                        <tr >
                            <td class="border px-4 py-2">{{ $i++ }}</td>
                            <td class="border text-center">
                                <input type="checkbox" name="ids[]" value="{{ $res->id }}" class="checkbox">
                            </td>
                            <td class="border px-4 py-2">{{ \Carbon\Carbon::parse($res->created_at)->format('d/m/Y') }}</td>
                            <td class="border px-4 py-2">{{ $res->code }}</td>
                            <td class="border px-4 py-2">{{ $res->depart }}</td>
                            <td class="border px-4 py-2">{{ $res->destination }}</td>
                            <td class="border px-4 py-2">{{ $res->date_depart }}</td>
                            <td class="border px-4 py-2">{{ $res->heure_depart }}</td>
                            <td class="border px-4 py-2">{{ $res->place }}</td>
                            <td class="border px-4 py-2">
                                @if ($res->user)
                                    <a href="{{ route('users.edit', $res->user->id) }}" class="text-primary">{{ $res->user->nom }}</a>
                                @endif
                            </td>
                            <td class="border px-4 py-2">{{ $res->telephone }}</td>
                            <td class="border px-4 py-2">
                                @php
                                if ($res->chauffeur) {
                                @endphp 
                                <a href="{{ route('users.edit', $res->chauffeur->id) }}" class="text-primary">{{ $res->chauffeur->name ?? '' }}</a>
                                @php
                                }
                                @endphp
                            </td>
                            <td class="border px-4 py-2">{{ $res->solde }}</td>
                            <td class="border px-4 py-2">{{ $res->gamme->nom ?? '' }}</td>
                            <td class="border px-4 py-2">
                                <span class="badge {{ $res->statut == 1 ? 'bg-success' : 'bg-danger' }}">
                                    {{ $res->statut == 1 ? 'Confirmée' : 'En attente' }}
                                </span>
                            </td>
                            <td class="border px-4 py-2">
                                @php
                                    if($res->statut==0){
                                @endphp
                                <a href="{{ route('reservations.edit', $res->id) }}" class="text-info"><span class="fa fa-pencil-alt"></span> Edit</a> |
                                <a href="#" class="text-danger delete-btn" data-id="{{ $res->id }}"><span class="fa fa-trash"></span> Suppr.</a>
                                @php
                                    }
                                @endphp

                                @php
                                    if($res->statut==1){
                                @endphp
                                <a href="{{ route('reservations.show', $res->id) }}" class="text-info"><span class="fa fa-eye"></span> Voir</a>
                                @php
                                    }
                                @endphp
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <button id="bulk-delete-btn" type="button" style="display:none;"></button>
            <button id="bulk-delete-btn3" type="button" style="display:none;"></button>
            <button id="bulk-delete-btn2" data-bs-toggle="modal" data-bs-target="#reservationModal" type="button" style="display:none;"></button>

            <div class="modal fade" id="reservationModal" tabindex="1" aria-labelledby="reservationModalLabel" aria-hidden="true">
                <div class="modal-dialog modal-md">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="reservationModalLabel">Choisir le chauffeur</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fermer"></button>
                        </div>

                        <div class="modal-body">
                            <label for="id_chauffeur">Chauffeur :</label>
                            <select name="id_chauffeur" id="id_chauffeur" class="form-control" required>
                                <option value="">-- Sélectionner un chauffeur --</option>
                                @foreach ($chauffeurs as $chauffeur)
                                    <option value="{{ $chauffeur->id }}">
                                        {{ $chauffeur->name }} ({{ $chauffeur->telephone }})
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary" >Affecter</button>
                        </div>
                    </div>
                </div>
            </div>

        </form>

        <div class="mt-4">
            {{ $reservations->links() }}
        </div>
    </div>
</x-app-layout>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        document.querySelectorAll('.delete-btn').forEach(button => {
            button.addEventListener('click', function () {
                const id = this.dataset.id;
                Swal.fire({
                    title: 'Supprimer cette réservation ?',
                    text: "Action irréversible !",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Oui, supprimer',
                    cancelButtonText: 'Annuler'
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.getElementById('delete-form-' + id).submit();
                    }
                });
            });
        });

        document.getElementById('check-all').addEventListener('change', function () {
            document.querySelectorAll('.checkbox').forEach(cb => cb.checked = this.checked);
        });

        document.getElementById('bulk-delete-btn').addEventListener('click', function () {
            const selected = document.querySelectorAll('.checkbox:checked');
            if (selected.length === 0) {
                Swal.fire('Aucun élément sélectionné', '', 'info');
                return;
            }
            Swal.fire({
                title: 'Confirmer la suppression ?',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Oui, supprimer',
                cancelButtonText: 'Annuler',
                confirmButtonColor: '#d33'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('bulk-delete-form').submit();
                }
            });
        });

        document.getElementById('bulk-delete-btn3').addEventListener('click', function () {
            const selected = document.querySelectorAll('.checkbox:checked');
            if (selected.length === 0) {
                Swal.fire('Aucun élément sélectionné', '', 'info');
                return;
            }
            Swal.fire({
                title: 'Desservir ces reservations ?',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Oui, desservir',
                cancelButtonText: 'Annuler',
                confirmButtonColor: '#d33'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('action_group').value="2";
                    document.getElementById('bulk-delete-form').submit();
                }
            });
        });

        document.getElementById('bulk-delete-btn1').addEventListener('click', function () {
            const selected = document.querySelectorAll('.checkbox:checked');
            if (selected.length === 0) {
                Swal.fire('Aucun élément sélectionné', '', 'info');
                return;
            }
            Swal.fire({
                title: 'Voulez-vous initier l\'affectation ?',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Oui, initier',
                cancelButtonText: 'Annuler',
                confirmButtonColor: '#d33'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('action_group').value="1";
                    document.getElementById('bulk-delete-btn2').click();
                }
            });
        });
    });
</script>
<!-- Bootstrap CSS -->

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
