<style>
    .form-control, .typeahead, .tt-query, .tt-hint, .select2-container--default .select2-selection--single .select2-search__field, .select2-container--default .select2-selection--single, .form-select {
        border: 1px solid #dee2e6;
        font-weight: 400;
        border-radius: 4px;
        height: 2.5rem !important;
    }
</style>
<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
            @include('prisons.navigation')
        </x-slot>


        <a href="{{ route('prisons.index') }}" class="btn btn-danger mb-3">+ Liste</a>
        <h4 style="float:right;width:fit-content;color:#333">Nouveau commissariat / Poste</h4>
        <hr>


        <div class="container">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="p-3">
                <!-- resources/views/admin/users/create.blade.php -->
                 <div class="card shadow p-4">
                    <form action="{{ route('prisons.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            <div class="col-lg-4">
                                <div class="mb-1">
                                    <label for="adresse" class="form-label">Code</label>
                                    <input type="text" name="code" class="form-control">
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="mb-1">
                                    <label for="name" class="form-label">Nom de la prison</label>
                                    <input type="text" name="name" class="form-control" required>
                                </div>
                            </div>

                            <div class="col-lg-4">
                                <div class="mb-1">
                                    <label for="type" class="form-label">Type</label>
                                    <select name="type" class="form-control" required>
                                        <option value="{{$type}}">{{$type}}</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-lg-4">
                                <div class="mb-1">
                                    <label for="directeur_id" class="form-label">Responsable</label>
                                    <select name="user_id" class="form-control" required>
                                        <option value="">-- Sélectionnez un directeur --</option>
                                        @foreach ($directeurs as $directeur)
                                            <option value="{{ $directeur->id }}">{{ $directeur->name }} ({{ $directeur->email }})</option>
                                        @endforeach
                                    </select>
                                </div>

                            </div>

                            
                            <div class="col-lg-4">
                                <div class="mb-1">
                                    <label for="telephone" class="form-label">Téléphone</label>
                                    <input type="text" name="telephone" class="form-control">
                                </div>
                            </div>

                            <div class="col-lg-4">
                                <div class="mb-1">
                                    <label for="email" class="form-label">Email</label>
                                    <input type="email" name="email" class="form-control">
                                </div>
                            </div>

                            <div class="col-lg-4">
                                <div class="mb-1">
                                    <label for="date_ouverture" class="form-label">Date d'ouverture</label>
                                    <input type="date" name="date_ouverture" class="form-control">
                                </div>
                            </div>

                            <div class="col-lg-4">
                                <div class="mb-1">
                                    <label for="statut" class="form-label">Statut</label>
                                    <select name="is_active" class="form-control">
                                        <option value="1">Actif</option>
                                        <option value="0">Inactif</option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-lg-4">
                                <div class="mb-1">
                                    <label for="latitude" class="form-label">Latitude</label>
                                    <input type="text" name="latitude" class="form-control">
                                </div>
                            </div>

                            <div class="col-lg-4">
                                <div class="mb-1">
                                    <label for="longitude" class="form-label">Longitude</label>
                                    <input type="text" name="longitude" class="form-control">
                                </div>
                            </div>

                            <div class="col-lg-4">
                                <div class="mb-1">
                                    <label for="longitude" class="form-label">Capacité</label>
                                    <input type="text" name="capacity" class="form-control">
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="mb-1">
                                    <label for="longitude" class="form-label">Adresse</label>
                                    <input type="text" name="location" class="form-control">
                                </div>
                            </div>

                            <div class="col-lg-4">
                                <div class="mb-1">
                                    <label for="quartier_id" class="form-label">Quartier</label>
                                    <select name="quartier_id" class="form-control" required>
                                        <option value="">-- Sélectionner --</option>
                                        @foreach($quartiers as $quartier)
                                            <option value="{{ $quartier->id }}">{{ $quartier->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                        </div>

                        <div class="text-end mt-4">
                            <button type="submit" class="btn btn-danger">Enregistrer</button>
                        </div>
                    </form>
                </div>

            </div>
                
        </div>
    </div>
</x-app-layout>

