<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        h2 { text-align: center; text-decoration: underline; }
        .section { margin-bottom: 15px; }
        .bold { font-weight: bold; }
    </style>
</head>
<body>
    <h2>PROCÈS-VERBAL D’ARRESTATION</h2>

    <div class="section">
        <p><span class="bold">PV N° :</span> {{ $pv_number }}</p>
        <p><span class="bold">Lieu :</span> {{ $poste }}</p>
        <p><span class="bold">Date :</span> {{ \Carbon\Carbon::parse($date)->format('d/m/Y') }} à {{ $heure }}</p>
    </div>

    <div class="section">
        <p><span class="bold">Chef de poste :</span> {{ $arrestation->user->name }}</p>
        <p><span class="bold">Grade / Fonction :</span> {{ $grade }}</p>
        <p><span class="bold">Matricule :</span> {{ $matricule }}</p>
    </div>

    <div class="section">
        <h4>Identité du prisonnier :</h4>
        <p><span class="bold">Nom :</span> {{ $prisonnier->nom }}</p>
        <p><span class="bold">Prénom :</span> {{ $prisonnier->prenom }}</p>
        <p><span class="bold">Date et lieu de naissance :</span> {{ $prisonnier->date_naissance }} à {{ $prisonnier->lieu_naissance }}</p>
        <p><span class="bold">Nationalité :</span> {{ $prisonnier->nationalite }}</p>
        <p><span class="bold">Domicile :</span> {{ $prisonnier->adresse ?? 'N/A' }}</p>
    </div>

    <div class="section">
        <h4>Circonstances de l’arrestation :</h4>
        <p><span class="bold">Date et heure :</span> {{ $arrestation->created_at->format('d/m/Y H:i') }}</p>
        <p><span class="bold">Lieu :</span> {{ $arrestation->lieu ?? 'N/A' }}</p>
         <p><span class="bold">Motif :</span></p>
         <ul>
             @foreach($arrestation->crimes as $crime)
                <li>{{ $crime->code }} - {{ $crime->libelle }}</li>
            @endforeach
         </ul>
        <hr>
        <p>
           <b>
             ### MESURES PRISES
           </b><br>

            - L’individu a été informé de ses droits conformément à la loi en vigueur.  
            - Il a été conduit au Poste de Police de {{$arrestation->prison->name}}, pour être entendu et placé en garde à vue.  
            - Une enquête est en cours sous la direction du parquet près le Tribunal de Grande Instance de [ville].

            Le présent procès-verbal est rédigé pour servir et valoir ce que de droit.
        </p>
    </div>

    <div class="section">
        <p>Fait à {{ $poste }}, le {{ \Carbon\Carbon::parse($date)->format('d/m/Y') }}</p>
        <p>Signature du Chef de Poste</p><br><br>
        <p>__________________________</p>
        <p>{{ $chef }} – {{ $grade }}</p>
    </div>
</body>
</html>
