<style>
    .form-control, .typeahead, .tt-query, .tt-hint, .select2-container--default .select2-selection--single .select2-search__field, .select2-container--default .select2-selection--single, .form-select {
        border: 1px solid #dee2e6;
        font-weight: 400;
        border-radius: 4px;
        height: 2.5rem !important;
    }
</style>
<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
            @include('prisons.navigation')
        </x-slot>


        <a href="{{ route('prisons.index') }}" class="btn btn-danger mb-3">+ Liste</a>
        <h4 style="float:right;width:fit-content;color:#333">Edition commissariat / Poste</h4>
        <hr>


        <div class="container">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="p-3">
                <!-- resources/views/admin/users/create.blade.php -->
                 <div class="card shadow p-4">
                   <form action="{{ route('prisoniers.update', $prisonier->id) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT') <!-- Cette ligne indique qu'on effectue une mise à jour (PUT) -->

                        <div class="row">
                            <!-- Nom -->
                            <div class="col-md-4 mb-1">
                                <label for="nom" class="form-label">Nom</label>
                                <input type="text" class="form-control" name="nom" id="nom" value="{{ old('nom', $prisonier->nom) }}" required>
                            </div>

                            <!-- Prénom -->
                            <div class="col-md-4 mb-1">
                                <label for="prenom" class="form-label">Prénom</label>
                                <input type="text" class="form-control" name="prenom" id="prenom" value="{{ old('prenom', $prisonier->prenom) }}" required>
                            </div>

                            <!-- Matricule -->
                            <div class="col-md-4 mb-1">
                                <label for="matricule" class="form-label">Matricule</label>
                                <input type="text" class="form-control" readonly value="{{ old('matricule', $prisonier->matricule) }}" name="matricule" id="matricule" required>
                            </div>

                            <!-- Sexe -->
                            <div class="col-md-4 mb-1">
                                <label for="sexe" class="form-label">Sexe</label>
                                <select class="form-select" name="sexe" id="sexe" required>
                                    <option value="">-- Sélectionner --</option>
                                    <option value="Homme" {{ old('sexe', $prisonier->sexe) == 'Homme' ? 'selected' : '' }}>Homme</option>
                                    <option value="Femme" {{ old('sexe', $prisonier->sexe) == 'Femme' ? 'selected' : '' }}>Femme</option>
                                </select>
                            </div>

                            <!-- Date de naissance -->
                            <div class="col-md-4 mb-1">
                                <label for="date_naissance" class="form-label">Date de naissance</label>
                                <input type="date" class="form-control" name="date_naissance" id="date_naissance" value="{{ old('date_naissance', $prisonier->date_naissance) }}">
                            </div>

                            <!-- Lieu de naissance -->
                            <div class="col-md-4 mb-1">
                                <label for="lieu_naissance" class="form-label">Lieu de naissance</label>
                                <input type="text" class="form-control" name="lieu_naissance" id="lieu_naissance" value="{{ old('lieu_naissance', $prisonier->lieu_naissance) }}">
                            </div>

                            <!-- Nationalité -->
                            <div class="col-md-4 mb-1">
                                <label for="nationalite" class="form-label">Nationalité</label>
                                <input type="text" class="form-control" name="nationalite" id="nationalite" value="{{ old('nationalite', $prisonier->nationalite) }}">
                            </div>

                            <!-- Statut matrimonial -->
                            <div class="col-md-4 mb-1">
                                <label for="statut_matrimonial" class="form-label">Statut matrimonial</label>
                                <select class="form-select" name="statut_matrimonial" id="statut_matrimonial">
                                    <option value="">-- Sélectionner --</option>
                                    <option value="Célibataire" {{ old('statut_matrimonial', $prisonier->statut_matrimonial) == 'Célibataire' ? 'selected' : '' }}>Célibataire</option>
                                    <option value="Marié(e)" {{ old('statut_matrimonial', $prisonier->statut_matrimonial) == 'Marié(e)' ? 'selected' : '' }}>Marié(e)</option>
                                    <option value="Divorcé(e)" {{ old('statut_matrimonial', $prisonier->statut_matrimonial) == 'Divorcé(e)' ? 'selected' : '' }}>Divorcé(e)</option>
                                    <option value="Veuf(ve)" {{ old('statut_matrimonial', $prisonier->statut_matrimonial) == 'Veuf(ve)' ? 'selected' : '' }}>Veuf(ve)</option>
                                </select>
                            </div>

                            <!-- Photo -->
                            <div class="col-md-4 mb-1">
                                <label for="photo" class="form-label">Photo</label>
                                <input type="file" class="form-control" name="photo" id="photo" accept="image/*">
                            </div>

                            <!-- Statut -->
                            <div class="col-md-4 mb-1">
                                <label for="statut" class="form-label">Statut</label>
                                <select class="form-select" name="statut" id="statut">
                                    <option value="Arrêté" {{ old('statut', $prisonier->statut) == 'Arrêté' ? 'selected' : '' }}>Arrêté</option>
                                    <option value="Libéré" {{ old('statut', $prisonier->statut) == 'Libéré' ? 'selected' : '' }}>Libéré</option>
                                    <option value="Transféré" {{ old('statut', $prisonier->statut) == 'Transféré' ? 'selected' : '' }}>Transféré</option>
                                </select>
                            </div>

                        </div>

                        <!-- Bouton de soumission -->
                        <div class="mt-4">
                            <button type="submit" class="btn btn-danger">Mettre à jour</button>
                            <a href="{{ route('prisoniers.index') }}" class="btn btn-secondary">Annuler</a>
                        </div>

                    </form>


                </div>

            </div>
                
        </div>
    </div>
</x-app-layout>

