<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
            @include('prisoniers.navigation')
        </x-slot>

        <a href="{{ route('prisoniers.arrestation.create') }}" class="btn btn-danger shadow" >+ Nouveau</a>
        <h4 style="float:right;width:fit-content;color:#333">{{$title}}</h4>
        <hr>
        
        <div class="card p-2 shadow">
            <table class="table table-bordered table-striped table-hover" id="myTable">
                <thead>
                    <tr>
                        <th>Matricule</th>
                        <th>Prisonier</th>
                        <th>Date d'Arrestation</th>
                        <th>Prison</th>
                        <th>Autorité Responsable</th>
                        <th>Statut</th>
                        <th>Crimes Associés</th>
                        @if(Auth::user()->role === 'admin')
                            <th>Action</th>
                        @endif
                    </tr>
                </thead>
                <tbody>
                    @foreach($arrestations as $arrestation)
                        <tr>
                            <td>{{ $arrestation->prisonier->matricule }}</td>
                            <td>{{ $arrestation->prisonier->nom }}{{ $arrestation->prisonier->prenom }}</td>
                            <td>{{ $arrestation->date_arrestation }}</td>
                            <td>{{ $arrestation->prison->name }}</td>
                            <td>{{ $arrestation->user->name }}</td>
                            <td>{{ $arrestation->statut }}</td>
                            <td>
                                <ul class="mb-0">
                                    @foreach($arrestation->crimes as $crime)
                                        <li>{{ $crime->code }} - {{ $crime->libelle }}</li>
                                    @endforeach
                                </ul>
                            </td>

                            @if(Auth::user()->role === 'admin')
                                <td>
                                     <a href="{{ route('prisonier.arrestation.generate', $arrestation->id) }}" >👁️</a>
                                    <a href="{{ route('prisonier.arrestation.edit', $arrestation->id) }}">✏️</a>
                                    <button onclick="confirmDelete({{ $crime->id }})">🗑️</button>
                                    <a href="{{ route('crimes.detail', $crime->id) }}" >👁️</a>
                                </td>
                            @endif
                            
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

    </div>

</x-app-layout>

 
<script>
    function confirmDelete(userId) {
        Swal.fire({
            title: 'Êtes-vous sûr ?',
            text: "Cette action est irréversible.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Oui, supprimer',
            cancelButtonText: 'Annuler'
        }).then((result) => {
            if (result.isConfirmed) {
                document.getElementById('delete-form-' + userId).submit();
            }
        });
    }
</script>

<script>
    document.getElementById('check-all').addEventListener('change', function () {
        const checkboxes = document.querySelectorAll('.checkbox');
        checkboxes.forEach(cb => cb.checked = this.checked);
    });

    document.getElementById('bulk-delete-btn').addEventListener('click', function () {
        const form = document.getElementById('bulk-delete-form');
        const selected = form.querySelectorAll('.checkbox:checked');

        if (selected.length === 0) {
            Swal.fire('Aucun élément sélectionné', 'Veuillez sélectionner au moins un utilisateur.', 'info');
            return;
        }

        Swal.fire({
            title: 'Confirmer la suppression ?',
            text: "Les utilisateurs sélectionnés seront supprimés.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Oui, supprimer',
            cancelButtonText: 'Annuler',
            confirmButtonColor: '#d33'
        }).then((result) => {
            if (result.isConfirmed) {
                form.submit();
            }
        });
    });
</script>


<!-- Bootstrap JS avec Popper -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

