<style>
    .form-control, .typeahead, .tt-query, .tt-hint, .select2-container--default .select2-selection--single .select2-search__field, .select2-container--default .select2-selection--single, .form-select {
        border: 1px solid #dee2e6;
        font-weight: 400;
        border-radius: 4px;
        height: 2.5rem !important;
    }
    
</style>
<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
            @include('prisons.navigation')
        </x-slot>


        <a href="{{ route('prisoniers.arrestation.index') }}" class="btn btn-danger mb-3">+ Liste</a>
        <h4 style="float:right;width:fit-content;color:#333">Modification d'une arrestation</h4>
        <hr>


        <div class="container">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="p-3">
                <h4>
                    <b>{{ $arrestation->prisonier->matricule }}</b> {{ $arrestation->prisonier->nom }} {{ $arrestation->prisonier->prenom }} <hr>
                </h4>
                <form action="{{ route('prisonier.arrestation.update', $arrestation->id) }}" method="POST">
                    @csrf
                    @method('PUT')
                    <div class="card shadow p-2 mb-2">
                        <div class="row">
                            <div class="col-lg-6">
                                <h4>Ses crimes</h4><hr>
                                <input type="hidden" value="{{ $arrestation->prisonier->id }}" name="prisonier_id">
                                <ul>
                                    @foreach($crime_prisoniers as $crime_prisonier)
                                    <li>
                                        <input type="checkbox" name="crimes[]" value="{{ $crime_prisonier->crime->id }}" 
                                            @if(in_array($crime_prisonier->crime->id, $arrestation->crimes->pluck('id')->toArray())) checked @endif>
                                        <label for="">{{ $crime_prisonier->crime->code }} - {{ $crime_prisonier->crime->libelle }}</label>
                                    </li>
                                    @endforeach
                                </ul>
                            </div>
                            <div class="col-lg-6">
                                <h4>Autres informations</h4><hr>
                                <div class="form-group">
                                    <label for="date_arrestation">Date d'Arrestation</label>
                                    <input type="date" id="date_arrestation" name="date_arrestation" class="form-control" 
                                        value="{{ old('date_arrestation', $arrestation->date_arrestation) }}" required>
                                </div>
                                <div class="form-group">
                                    <label for="lieu_arrestation">Lieu d'Arrestation</label>
                                    <select name="prison_id" id="prison_id" class="form-control" required>
                                        <option value="">-- Choisir --</option>
                                        @foreach($prisons as $prison)
                                            <option value="{{ $prison->id }}" 
                                                    @if(old('prison_id', $arrestation->prison_id) == $prison->id) selected @endif>
                                                {{ $prison->code }} - {{ $prison->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="autorite_responsable">Autorité Responsable</label>
                                    <select name="responsable_id" id="user_id" class="form-control" required>
                                        <option value="">-- Choisir --</option>
                                        @foreach($users as $user)
                                            <option value="{{ $user->id }}" 
                                                    @if(old('resonsable_id', $arrestation->responsable_id) == $user->id) selected @endif>
                                                {{ $user->name }} - {{ $user->role }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="statut">Statut</label>
                                    <select id="statut" name="statut" class="form-control" required>
                                        <option value="En attente" 
                                                @if(old('statut', $arrestation->statut) == 'En attente') selected @endif>
                                            En attente
                                        </option>
                                        <option value="Relâché" 
                                                @if(old('statut', $arrestation->statut) == 'Relâché') selected @endif>
                                            Relâché
                                        </option>
                                        <option value="Emprisonné" 
                                                @if(old('statut', $arrestation->statut) == 'Emprisonné') selected @endif>
                                            Emprisonné
                                        </option>
                                        <option value="Deferré" 
                                                @if(old('statut', $arrestation->statut) == 'Emprisonné') selected @endif>
                                            Deferré
                                        </option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="date_relachement">Date de Relâchement</label>
                                    <input type="date" id="date_relachement" name="date_relachement" class="form-control" 
                                        value="{{ old('date_relachement', $arrestation->date_relachement) }}">
                                </div>
                                <button class="btn btn-warning" type="submit">Mettre à jour</button>
                            </div>
                        </div>
                    </div>
                </form>

            </div>
                
        </div>
    </div>
</x-app-layout>

