<style>
    .form-control, .typeahead, .tt-query, .tt-hint, .select2-container--default .select2-selection--single .select2-search__field, .select2-container--default .select2-selection--single, .form-select {
        border: 1px solid #dee2e6;
        font-weight: 400;
        border-radius: 4px;
        height: 2.5rem !important;
    }
</style>
<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
            @include('prisoniers.navigation')
        </x-slot>


        <a href="{{ route('prisoniers.index') }}" class="btn btn-danger mb-1">+ Liste</a>
        <h4 style="float:right;width:fit-content;color:#333">{{$title}}</h4>
        <hr>


        <div class="content">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="p-3">
                <!-- resources/views/admin/users/create.blade.php -->
                <div class="card shadow p-2 mb-2">
                    <div class="row">
                        <div class="col-lg-4">
                            <form method="GET" action="{{ route('prisoniers.arrestation.create') }}">
                                <div class="mb-3">
                                    <label for="prisonnier_id" class="form-label">Sélectionnez un prisonier :</label>
                                    <select name="prisonier_id" id="prisonnier_id" class="form-control" onchange="this.form.submit()">
                                        <option value="">-- Choisir --</option>
                                        @foreach($prisoniers as $prisonnier)
                                            <option value="{{ $prisonnier->id }}" {{ request('prisonier_id') == $prisonnier->id ? 'selected' : '' }}>
                                                {{ $prisonnier->matricule }}-{{ $prisonnier->nom }} {{ $prisonnier->prenom }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </form>
                            
                        </div>
                    </div>
                </div>
                @if ($id>0)
                <form action="{{ route('prisoniers.arrestation.store') }}" method="POST">
                    @csrf
                    <div class="card shadow p-2 mb-2">
                        <div class="row">
                            <div class="col-lg-6">
                                <h4>Ses crimes</h4><hr>
                                <input type="hidden" name="prisonier_id" value="{{ $id }}">
                                <ul>
                                    @foreach($crime_prisoniers as $crime_prisonier)
                                    <li>
                                        
                                        <input type="checkbox" name="crimes[]" value="{{ $crime_prisonier->crime->id }}">
                                        <label for="">
                                            {{ $crime_prisonier->crime->code }}-{{ $crime_prisonier->crime->libelle }}
                                        </label>
                                    </li>
                                    @endforeach
                                </ul>
                            </div>
                            <div class="col-lg-6">
                                <h4>Autres informations</h4><hr>
                                <div class="form-group">
                                    <label for="date_arrestation">Date d'Arrestation</label>
                                    <input type="date" id="date_arrestation" name="date_arrestation" class="form-control" value="{{ old('date_arrestation') }}" required>
                                </div>
                                <div class="form-group">
                                    <label for="lieu_arrestation">Lieu d'Arrestation</label>
                                    <select name="prison_id" id="prison_id" class="form-control">
                                        <option value="">-- Choisir --</option>
                                        @foreach($prisons as $prison)
                                            <option value="{{ $prison->id }}">
                                                {{ $prison->code }}-{{ $prison->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="autorite_responsable">Autorité Responsable</label>
                                    <select name="responsable_id" id="prison_id" class="form-control">
                                        <option value="">-- Choisir --</option>
                                        @foreach($users as $user)
                                            <option value="{{ $prison->id }}">
                                                {{ $user->name }}- {{ $user->role }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                
                                <div class="form-group">
                                    <label for="statut">Statut</label>
                                    <select id="statut" name="statut" class="form-control" required>
                                        <option value="En attente" {{ old('statut') == 'En attente' ? 'selected' : '' }}>En attente</option>
                                        <option value="Relâché" {{ old('statut') == 'Relâché' ? 'selected' : '' }}>Relâché</option>
                                        <option value="Emprisonné" {{ old('statut') == 'Emprisonné' ? 'selected' : '' }}>Emprisonné</option>
                                        <option value="Deferré" {{ old('statut') == 'Deferré' ? 'selected' : '' }}>Deferré</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="date_relachement">Date de Relâchement</label>
                                    <input type="date" id="date_relachement" name="date_relachement" class="form-control" value="{{ old('date_relachement') }}">
                                </div>
                                <button class="btn btn-danger" type="submit">Enregistrer</button>
                            </div>
                        </div>
                    </div>
                </form>
                   
                @endif

            </div>
                
        </div>
    </div>
</x-app-layout>

