<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
            @include('parametres.navigation')
        </x-slot>

        <h4 style="float:right;width:fit-content;color:#333">Ensemble des paramètres</h4>
        <hr>
        

    </div>

</x-app-layout>

<script>
    function confirmDelete(userId) {
        Swal.fire({
            title: 'Êtes-vous sûr ?',
            text: "Cette action est irréversible.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Oui, supprimer',
            cancelButtonText: 'Annuler'
        }).then((result) => {
            if (result.isConfirmed) {
                document.getElementById('delete-form-' + userId).submit();
            }
        });
    }
</script>

<script>
    document.getElementById('check-all').addEventListener('change', function () {
        const checkboxes = document.querySelectorAll('.checkbox');
        checkboxes.forEach(cb => cb.checked = this.checked);
    });

    document.getElementById('bulk-delete-btn').addEventListener('click', function () {
        const form = document.getElementById('bulk-delete-form');
        const selected = form.querySelectorAll('.checkbox:checked');

        if (selected.length === 0) {
            Swal.fire('Aucun élément sélectionné', 'Veuillez sélectionner au moins un utilisateur.', 'info');
            return;
        }

        Swal.fire({
            title: 'Confirmer la suppression ?',
            text: "Les utilisateurs sélectionnés seront supprimés.",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Oui, supprimer',
            cancelButtonText: 'Annuler',
            confirmButtonColor: '#d33'
        }).then((result) => {
            if (result.isConfirmed) {
                form.submit();
            }
        });
    });
</script>


<!-- Bootstrap JS avec Popper -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

