<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ config('app.name', 'TOSAOBIKA') }}</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
        
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        
        <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
        <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.dataTables.min.css">
        <link rel="stylesheet" type="text/css" href="//cdn.datatables.net/2.3.2/css/dataTables.dataTables.min.css">


        <!-- Scripts -->
        @vite(['resources/css/app.css','resources/css/style.css', 'resources/js/app.js'])

        <style>
            td {
                border-bottom: 1px solid #ccc !important;
            }
        </style>
    </head>
    <body class="font-sans antialiased">
        <div class="min-h-screen bg-gray-100">
            @include('layouts.navigation')

            <!-- Page Heading -->
            @isset($header)
                <header class="bg-white shadow header" style="background: #0c0e0d !important;border-bottom: 3px solid #f82732;">
                    <div class="max-w-7xl mx-auto py-2 px-4 sm:px-6 lg:px-8">
                        {{ $header }}
                    </div>
                </header>
            @endisset

            <!-- Page Content -->
            <main>
                {{ $slot }}
            </main>
        </div>
        <script src="https://code.jquery.com/jquery-3.7.1.min.js" ></script>
        <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>

        <script type="text/javascript" src="//cdn.datatables.net/2.3.2/js/dataTables.min.js"></script>
        {{-- JS --}}
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
        <script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
        <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>
        <script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
        

        <script>
            $(document).ready(function() {
                $('#myTable').DataTable({
                    dom: 'Bfrtip',
                    pageLength: 100,
                    buttons: [
                        { extend: 'copy', className: 'btn btn-sm btn-outline-secondary' },
                        { extend: 'csv', className: 'btn btn-sm btn-outline-success' },
                        { extend: 'excel', className: 'btn btn-sm btn-outline-primary' },
                        { extend: 'pdf', className: 'btn btn-sm btn-outline-danger' },
                        { extend: 'print', className: 'btn btn-sm btn-outline-dark' }
                    ],
                    language: {
                        //url: '//cdn.datatables.net/plug-ins/1.13.6/i18n/fr-FR.json'
                    }
                });

                $('#myTable1').DataTable({
                    dom: 'Bfrtip',
                    pageLength: 100,
                    buttons: [
                        { extend: 'copy', className: 'btn btn-sm btn-outline-secondary' },
                        { extend: 'csv', className: 'btn btn-sm btn-outline-success' },
                        { extend: 'excel', className: 'btn btn-sm btn-outline-primary' },
                        { extend: 'pdf', className: 'btn btn-sm btn-outline-danger' },
                        { extend: 'print', className: 'btn btn-sm btn-outline-dark' }
                    ],
                    language: {
                       // url: '//cdn.datatables.net/plug-ins/1.13.6/i18n/fr-FR.json'
                    }
                });
                $('#myTable2').DataTable({
                    dom: 'Bfrtip',
                    pageLength: 100,
                    buttons: [
                        { extend: 'copy', className: 'btn btn-sm btn-outline-secondary' },
                        { extend: 'csv', className: 'btn btn-sm btn-outline-success' },
                        { extend: 'excel', className: 'btn btn-sm btn-outline-primary' },
                        { extend: 'pdf', className: 'btn btn-sm btn-outline-danger' },
                        { extend: 'print', className: 'btn btn-sm btn-outline-dark' }
                    ],
                    language: {
                        //url: '//cdn.datatables.net/plug-ins/1.13.6/i18n/fr-FR.json'
                    }
                });
                $('#myTable3').DataTable({
                    dom: 'Bfrtip',
                    pageLength: 100,
                    buttons: [
                        { extend: 'copy', className: 'btn btn-sm btn-outline-secondary' },
                        { extend: 'csv', className: 'btn btn-sm btn-outline-success' },
                        { extend: 'excel', className: 'btn btn-sm btn-outline-primary' },
                        { extend: 'pdf', className: 'btn btn-sm btn-outline-danger' },
                        { extend: 'print', className: 'btn btn-sm btn-outline-dark' }
                    ],
                    language: {
                       // url: '//cdn.datatables.net/plug-ins/1.13.6/i18n/fr-FR.json'
                    }
                });
            });
            </script>
    </body>
</html>
