<x-app-layout>
    <div class="container mx-auto px-4 py-6">

        <x-slot name="header">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                Modifier l’opération financière
            </h2>
        </x-slot>

        <a href="{{ route('finances.index') }}" class="btn btn-secondary mb-4">
            ← Retour à la liste
        </a>

        @if ($errors->any())
            <div class="alert alert-danger mb-4">
                <ul class="list-disc pl-5">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form action="{{ route('finances.update', $finance->id) }}" method="POST" class="bg-white p-6 rounded shadow-md">
            @csrf
            @method('PUT')

            <div class="row">
                <div class="col-lg-6">
                    <div class="mb-4">
                        <label for="sens" class="block font-medium text-sm text-gray-700">Sens de l’opération</label>
                        <select name="sens" id="sens" class="form-control" required>
                            <option value="entrée" {{ old('sens', $finance->sens ?? '') == 'entrée' ? 'selected' : '' }}>Entrée</option>
                            <option value="sortie" {{ old('sens', $finance->sens ?? '') == 'sortie' ? 'selected' : '' }}>Sortie</option>
                        </select>
                    </div>
                    <div class="mb-4">
                        <label for="reservation_id" class="block font-medium text-sm text-gray-700">Réservation liée</label>
                        <select name="reservation_id" id="reservation_id" class="form-control" required>
                            @foreach($reservations as $res)
                                <option value="{{ $res->id }}" {{ $finance->reservation_id == $res->id ? 'selected' : '' }}>
                                    {{ $res->code }} | {{ $res->depart }} → {{ $res->destination }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="mb-4">
                        <label for="type" class="block font-medium text-sm text-gray-700">Type d’opération</label>
                        <select name="type" id="type" class="form-control" required>
                            @foreach(['paiement_client', 'commission_chauffeur', 'remboursement', 'bonus', 'autre'] as $type)
                                <option value="{{ $type }}" {{ $finance->type == $type ? 'selected' : '' }}>
                                    {{ ucfirst(str_replace('_', ' ', $type)) }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="mb-4">
                        <label for="montant" class="block font-medium text-sm text-gray-700">Montant (XAF)</label>
                        <input type="number" step="0.01" name="montant" id="montant" class="form-control" value="{{ $finance->montant }}" required>
                    </div>

                   

                </div>
                <div class="col-lg-6">
                    <div class="mb-4">
                        <label for="source" class="block font-medium text-sm text-gray-700">Source</label>
                        <input type="text" name="source" id="source" class="form-control" value="{{ $finance->source }}" placeholder="Ex : client, admin, chauffeur">
                    </div>
                    <div class="mb-4">
                        <label for="description" class="block font-medium text-sm text-gray-700">Description</label>
                        <textarea name="description" id="description" rows="3" class="form-control">{{ $finance->description }}</textarea>
                    </div>

                    <div class="mb-4">
                        <label for="valide" class="block font-medium text-sm text-gray-700">Valide ?</label>
                        <select name="valide" id="valide" class="form-control">
                            <option value="1" {{ $finance->valide ? 'selected' : '' }}>Oui</option>
                            <option value="0" {{ !$finance->valide ? 'selected' : '' }}>Non</option>
                        </select>
                    </div>
                </div>
            </div>
            

            

            

            <div class="flex justify-end">
                <button type="submit" class="btn btn-primary">
                    Enregistrer les modifications
                </button>
            </div>
        </form>

    </div>
</x-app-layout>
