<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
            @include('cars.navigation')
        </x-slot>

        <a href="{{ route('gammes.index') }}" class="btn btn-primary">+ Gamme de vehicules</a>
        <h4 style="float:right;width:fit-content;color:#333">Nouvelle gamme</h4>
        <hr>

        @if ($errors->any())
            <div class="bg-red-100 text-red-800 p-4 rounded mb-4">
                <ul class="list-disc pl-5">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <div class="bg-white shadow rounded p-6 col-lg-6">
            <form method="POST" action="{{ route('gammes.store') }}">
                @csrf

                <div class="mb-4">
                    <label for="nom" class="block font-medium text-sm text-gray-700">Nom de la gamme :</label>
                    <input type="text" name="libelle" id="libelle" value="{{ old('libelle') }}"
                           class="form-input mt-1 block w-full border px-3 py-2 rounded" required>
                </div>

                <div class="mb-4">
                    <label for="tarif" class="block font-medium text-sm text-gray-700">Tarif (xaf) :</label>
                    <input type="number" name="tarif" id="tarif" value="{{ old('tarif') }}"
                           class="form-input mt-1 block w-full border px-3 py-2 rounded" step="0.01" required>
                </div>

                <div class="mb-4">
                    <label for="description" class="block font-medium text-sm text-gray-700">Description :</label>
                    <textarea name="description" id="description" rows="4"
                              class="form-textarea mt-1 block w-full border px-3 py-2 rounded">{{ old('description') }}</textarea>
                </div>

                <button type="submit"
                        class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                    Enregistrer
                </button>
            </form>
        </div>
    </div>
</x-app-layout>
