<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
            @include('cars.navigation')
        </x-slot>

        <a href="{{ route('gammes.index') }}" class="btn btn-primary mb-3">+ Gamme de vehicules</a>
        <h4 style="float:right;width:fit-content;color:#333">Affectations gamme aux véhicules</h4>
        <hr>
        @if (session('success'))
            <div class="alert alert-success mt-3 mb-4">
                {{ session('success') }}
            </div>
        @endif
        @if ($errors->any())
            <div class="bg-red-100 text-red-800 p-4 rounded mb-4">
                <ul class="list-disc pl-5">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        
        <div class="row">
            <div class="col-lg-4">
                <div class="mb-6 w-1/2">
                    <label for="gamme_filter" class="block text-sm font-medium text-gray-700">Choisir une gamme :</label>
                    <select id="gamme_filter" name="gamme_id"
                        class="mt-1 block w-full border border-gray-300 px-3 py-2 rounded-md shadow-sm">
                        <option value="">-- Toutes les gammes --</option>
                        @foreach($gammes as $gamme)
                            <option value="{{ $gamme->id }}" {{ request('gamme_id') == $gamme->id ? 'selected' : '' }}>
                                {{ $gamme->libelle }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="col-lg-8">
                <!-- Formulaire d'affectation -->
                <form method="POST" action="{{ route('cars.affecter-gamme') }}">
                    @csrf

                    <!-- Choix de la gamme à affecter -->
                    <div class="mb-4 w-1/2">
                        <label for="gamme_id" class="block text-sm font-medium text-gray-700">Affecter à cette gamme :</label>
                        <select style="background: #ccc;" name="gamme_id" id="gamme_id" readonly  disabled class="mt-1 block w-full border border-gray-300 px-3 py-2 rounded-md shadow-sm" required>
                            <option value="">-- Sélectionner --</option>
                            @foreach($gammes as $gamme)
                                <option value="{{ $gamme->id }}" {{ request('gamme_id') == $gamme->id ? 'selected' : '' }}>{{ $gamme->nom }}</option>
                            @endforeach
                        </select>
                    </div>
                    <input type="hidden" name="gamme_id" value="{{request('gamme_id') }}">
                    <!-- Tableau des voitures -->
                    <table class="table-auto w-full border-collapse border border-gray-300 shadow mb-2">
                        <thead>
                            <tr class="bg-gray-200">
                                <th class="border px-4 py-2">#</th>
                                <th class="border text-center" width="30"><input type="checkbox" id="check-all"></th>
                                <th class="border px-4 py-2">Marque</th>
                                <th class="border px-4 py-2">Modèle</th>
                                <th class="border px-4 py-2">Immatriculation</th>
                                <th class="border px-4 py-2">Gamme actuelle</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php $i = 1; $gammeFiltree = request('gamme_id'); @endphp
                            @foreach ($cars as $car)
                                <tr>
                                    <td class="border px-4 py-2">{{ $i++ }}</td>
                                    <td class="border text-center">
                                        <input type="checkbox" name="car_ids[]" value="{{ $car->id }}" class="checkbox"
                                            {{ $gammeFiltree && $car->id_gamme == $gammeFiltree ? 'checked' : '' }}>
                                    </td>
                                    <td class="border px-4 py-2">{{ $car->marque }}</td>
                                    <td class="border px-4 py-2">{{ $car->modele }}</td>
                                    <td class="border px-4 py-2">{{ $car->immatriculation }}</td>
                                    <td class="border px-4 py-2">{{ $car->gamme->libelle ?? 'Aucune' }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>

                    <button type="submit" class="btn btn-primary">
                        Affecter la gamme
                    </button>
                </form>
            </div>
        </div>
        <!-- Sélecteur de gamme avec rechargement auto -->
        

        
    </div>
</x-app-layout>

<script>
    document.getElementById('gamme_filter').addEventListener('change', function () {
        const gammeId = this.value;
        const url = new URL(window.location.href);
        if (gammeId) {
            url.searchParams.set('gamme_id', gammeId);
        } else {
            url.searchParams.delete('gamme_id');
        }
        window.location.href = url.toString();
    });

    // Check all
    document.getElementById('check-all').addEventListener('change', function () {
        document.querySelectorAll('.checkbox').forEach(cb => cb.checked = this.checked);
    });
</script>
