<x-app-layout>
    <div class="container mx-auto px-4 py-6">
        <x-slot name="header">
            @include('cars.navigation')
        </x-slot>

        <a href="{{ route('cars.index') }}" class="btn btn-primary">← Retour à la liste</a>
        
        <h4 style="float:right;width:fit-content;color:#333">Modification véhicule</h4>
        <hr>

        <div class="container">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="p-3 shadow">
                <form action="{{ route('cars.affecterChauffeur', $car->id) }}" method="POST">
                        @csrf
                        <label for="chauffeur_id">Sélectionner un chauffeur :</label>
                        <select name="chauffeur_id" id="chauffeur_id" required>
                            <option value=""></option>
                            @foreach ($chauffeurs as $chauffeur)
                                <option value="{{ $chauffeur->id }}" {{ $car->id_chauffeur == $chauffeur->id ? 'selected' : '' }}>
                                    {{ $chauffeur->nom }}
                                </option>
                            @endforeach
                        </select>
                        <button type="submit" class="btn btn-primary">Affecter</button>
                    </form>
                    <hr>
                <form method="POST" action="{{ route('cars.update', $car->id) }}" enctype="multipart/form-data" class="space-y-4">
                    @csrf
                    @method('PUT')

                    <div class="row">
                        <div class="col-lg-4">
                            <div class="form-group">
                                <label>Marque :</label>
                                <input type="text" name="marque" value="{{ old('marque', $car->marque) }}" class="form-control w-full border px-3 py-2" required>
                            </div>
                            <div class="form-group">
                                <label>Modèle :</label>
                                <input type="text" name="modele" value="{{ old('modele', $car->modele) }}" class="form-control w-full border px-3 py-2" required>
                            </div>
                            <div class="form-group">
                                <label>Année :</label>
                                <input type="number" name="annee" value="{{ old('annee', $car->annee) }}" class="form-control w-full border px-3 py-2" required>
                            </div>
                            <div class="form-group">
                                <label>Immatriculation :</label>
                                <input type="text" name="immatriculation" value="{{ old('immatriculation', $car->immatriculation) }}" class="form-control w-full border px-3 py-2" required>
                            </div>
                        </div>

                        <div class="col-lg-4">
                            <div class="form-group">
                                <label>Carburant :</label>
                                <select name="carburant" class="form-control w-full border px-3 py-2">
                                    @foreach (['essence', 'diesel', 'électrique', 'hybride'] as $fuel)
                                        <option value="{{ $fuel }}" {{ old('carburant', $car->carburant) == $fuel ? 'selected' : '' }}>
                                            {{ ucfirst($fuel) }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group">
                                <label>Transmission :</label>
                                <select name="transmission" class="form-control w-full border px-3 py-2">
                                    <option value="manuelle" {{ old('transmission', $car->transmission) == 'manuelle' ? 'selected' : '' }}>Manuelle</option>
                                    <option value="automatique" {{ old('transmission', $car->transmission) == 'automatique' ? 'selected' : '' }}>Automatique</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label>Kilométrage :</label>
                                <input type="number" name="kilometrage" value="{{ old('kilometrage', $car->kilometrage) }}" class="form-control w-full border px-3 py-2">
                            </div>
                            <div class="form-group">
                                <label>Nombre de places :</label>
                                <input type="number" name="nombre_places" value="{{ old('nombre_places', $car->nombre_places) }}" class="form-control w-full border px-3 py-2">
                            </div>
                        </div>

                        <div class="col-lg-4">
                            <div class="form-group">
                                <label>Propriétaire :</label>
                                <select name="id_proprietaire" class="form-control w-full border px-3 py-2">
                                    @foreach ($users as $user)
                                        <option value="{{ $user->id }}" {{ old('id_proprietaire', $car->id_proprietaire) == $user->id ? 'selected' : '' }}>
                                            {{ $user->nom }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group">
                                <label>Statut :</label>
                                <select name="statut" class="form-control w-full border px-3 py-2">
                                    <option value="1" {{ old('statut', $car->statut) == 1 ? 'selected' : '' }}>
                                        Disponible
                                    </option>
                                    <option value="2" {{ old('statut', $car->statut) == 2 ? 'selected' : '' }}>
                                        occupé
                                    </option>
                                    <option value="0" {{ old('statut', $car->statut) == 0 ? 'selected' : '' }}>
                                        Maintenance
                                    </option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label>Image :</label>
                                <input type="file" name="image" class="form-control w-full border px-3 py-2">
                                @if ($car->image)
                                    <div class="mt-2">
                                        <img src="{{ asset('storage/' . $car->image) }}" alt="Image du véhicule" class="h-20">
                                    </div>
                                @endif
                            </div>
                            <div class="form-group">
                                <label>Description :</label>
                                <textarea name="description" class="form-control w-full border px-3 py-2">{{ old('description', $car->description) }}</textarea>
                            </div>
                        </div>
                    </div>

                    <button type="submit" class="btn btn-primary">Mettre à jour</button>
                </form>
            </div>
        </div>
    </div>
</x-app-layout>
