<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Zone;
use App\Models\Arrondissement;
use App\Models\Quartier;
use App\Models\Prison;
use App\Models\Ville;

class ZoneSeeder extends Seeder {
    public function run(): void {
        $bzv = Ville::where('code', 'BZV')->first();
        $pnr = Ville::where('code', 'PNR')->first();

        Zone::create(['name' => 'Centre-Ville', 'code' => 'CV-BZV', 'description' => 'Zone centrale', 'ville_id' => $bzv->id]);
        Zone::create(['name' => 'Tié-Tié', 'code' => 'TT-PNR', 'description' => 'Zone sud', 'ville_id' => $pnr->id]);
    }
}
