<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Zone;
use App\Models\Arrondissement;
use App\Models\Quartier;
use App\Models\Prison;
use App\Models\Ville;

class QuartierSeeder extends Seeder {
    public function run(): void {
        $mkl = Arrondissement::where('code', 'MKL')->first();
        $mvv = Arrondissement::where('code', 'MVV')->first();

        Quartier::create(['name' => 'Bacongo', 'code' => 'BCG', 'description' => 'Quartier populaire', 'arrondissement_id' => $mkl->id]);
        Quartier::create(['name' => 'Loandjili', 'code' => 'LDJ', 'description' => 'Quartier de Pointe-Noire', 'arrondissement_id' => $mvv->id]);
    }
}
