<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('crimes', function (Blueprint $table) {
            $table->id();
            $table->string('code')->unique();
            $table->string('libelle');
            $table->text('description')->nullable();
            $table->enum('niveau_gravite', ['Faible', 'Moyenne', 'Élevée']);
            $table->string('loi_associee')->nullable();
            $table->date('date_crime')->nullable();
            $table->string('lieu_crime')->nullable();
            $table->timestamps();
        });

        Schema::create('crime_photos', function (Blueprint $table) {
            $table->id();
            $table->foreignId('crime_id')->constrained()->onDelete('cascade');
            $table->string('photo_path');
            $table->timestamps();
        });

        Schema::create('crime_prisonnier', function (Blueprint $table) {
            $table->id();
            $table->foreignId('crime_id')->constrained()->onDelete('cascade');
            $table->foreignId('prisonnier_id')->constrained()->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('crime_prisonnier');
        Schema::dropIfExists('crime_photos');
        Schema::dropIfExists('crimes');
    }
};
