<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Prison extends Model {
    protected $fillable = [
        'name', 'code', 'description', 'type', 'location', 'capacity',
        'phone', 'email', 'latitude', 'longitude', 'is_active', 'quartier_id','user_id',
    ];
    public function quartier() { return $this->belongsTo(Quartier::class); }
    public function user() { return $this->belongsTo(User::class,'user_id'); }
    public function users() { return $this->hasMany(User::class, 'assigned_prison_id'); }
    public function arrondissement() {
        return $this->quartier->arrondissement ?? null;
    }

    public function zone() {
        return $this->quartier->arrondissement->zone ?? null;
    }

    public function ville() {
        return $this->quartier->arrondissement->zone->ville ?? null;
    }
    public function arrestations() {
        return $this->hasMany(Arrestation::class);
    }

    public function materielPrisons() {
        return $this->hasMany(MaterielPrison::class);
    }

    public function operations() {
        return $this->hasMany(Operation::class);
    }
}
