<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Crime extends Model
{
    protected $fillable = [
        'code', 'libelle', 'description', 'niveau_gravite', 'loi_associee', 'date_crime', 'lieu_crime','quartier_id'
    ];

    public function prisonniers()
    {
        return $this->belongsToMany(Prisonier::class, 'crime_prisonnier', 'crime_id', 'prisonnier_id')
                    ->withPivot('rôle', 'date_implication', 'condamnation');
    }

    public function photos(): HasMany
    {
        return $this->hasMany(CrimePhoto::class);
    }

    public function quartier()
    {
        return $this->belongsTo(Quartier::class);
    }
}