<?php

namespace App\Http\Controllers;

use App\Models\Quartier;
use App\Models\Arrondissement;
use Illuminate\Http\Request;

class QuartierController extends Controller
{
    public function index() {
       $quartiers = Quartier::all();
        return view('quartiers.index', compact('quartiers'));
    }

    public function create() {
         $arrondissements = Arrondissement::all();

        return view('quartiers.create', compact('arrondissements'));
    }

    public function store(Request $request) {
        Quartier::create($request->all());
        return redirect()->route('quartier.index');
    }

    public function edit($id) {
       $quartier=Quartier::findOrFail($id);
       $arrondissements = Arrondissement::all();

        return view('quartiers.edit', compact('quartier', 'arrondissements'));
    }



    public function update(Request $request,$id) {
        $quartier = Quartier::findOrFail($id);

        // Validation des données reçues depuis le formulaire
       $validated= $request->validate([
            'code' => 'required|string|max:255',
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'arrondissement_id' => 'required|numeric|exists:arrondissements,id',
             // Vérifie que la prison existe
        ]);

       $quartier->update($validated);
        return redirect()->route('quartier.index');
    }

    public function destroy(quartier$quartier) {
       $quartier->delete();
        return redirect()->route('quartiers.index');
    }
}
