<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class ApiController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
       
    }

    /**
     * Show the form for creating a new resource.
     */
    public function phone(Request $request)
    {
        
        if($request->telephone!="" && $request->otp!=""){

            $otp = $request->otp;
            $telephone = $request->telephone;
           
           $user = DB::table('users')
                    ->where('telephone', $telephone)
                    ->first();

            if($user){
                DB::table('users')
                    ->where('telephone', $telephone)
                    ->update(['otp' => $otp]);

                return response()->json([
                    'success' => true,
                    'data' =>$user
                ]);
            }else{
                return response()->json([
                    'success' => false,
                    'message' => 'telephone not found',
                ]);
            }

           
        }else{
            return response()->json([
                'success' => false,
                'message' => 'telephone is required',
            ]);
        }

        
    }

    public function user_insert(Request $request){

        if($request->telephone!="" && $request->otp!=""){

            $otp = $request->otp;
            $telephone = $request->telephone;
            DB::table('users')->insert([
                'name' => "EVOX-".$otp,
                'telephone' => $telephone,
                'email' => $telephone."@evox.com",
                'password' => bcrypt($telephone.'-evox-069508532'),
            ]);

            $user = DB::table('users')
                    ->where('telephone', $telephone)
                    ->first();

            return response()->json([
                'success' => true,
                'description' =>"Félicitation votre compte a bien été créer",
                'data' => $user
            ]);
        }else{

            return response()->json([
                'success' => false,
                'message' => 'telephone is required',
            ]);
        }
    }

    public function update_user_statut(Request $request){
        if($request->id!="" && $request->statut!=""){

            $statut = $request->statut;
            $id = $request->id;

            DB::table('users')->where('id', $id)->update(['statut' => $statut]);

            $user=DB::table('users')->where('id', $id)->first();

            return response()->json([
                'success' => true,
                'description' =>"Félicitation votre compte a bien été activer",
                'data' => $user
            ]);
        }else{

            return response()->json([
                'success' => false,
                'message' => 'Compte non activer',
            ]);
        }
    }

    public function users_by_id(Request $request){

        if($request->id!=""){

            $id = $request->id;

            $user=DB::table('users')->where('id', $id)->first();

            return response()->json([
                'success' => true,
                'data' => $user
            ]);
        }else{

            return response()->json([
                'success' => false,
                'message' => 'Compte non activer',
            ]);
        }
    }

    public function category_car(){
        $category = DB::table('category')->get();
        return response()->json([
            'success' => true,
            'data' => $category
        ]);
    }
    public function add_position_user( Request $request){

        if($request->id!="" && $request->latitude!="" && $request->longitude!=""){

            $id = $request->id;
            $latitude = $request->latitude;
            $longitude = $request->longitude;

            // insert
            DB::table('location')->insert([
                'latitude' => $latitude,
                'longitude' => $longitude,
                'id_user' => $id,
                'date_save' => date('Y-m-d H:i:s')
            ]);
            return response()->json([
                'success' => true,
                'message' => "Position ajoutées avec succès"
            ]);
        }else{

            return response()->json([
                'success' => false,
                'message' => 'Informations erronées',
            ]);
        }


    }

    public function prix_itineraire( Request $request){
       $depart = $request->depart;
       $destination = $request->destination;
       if($depart=="" || $destination==""){
           return response()->json([
               'success' => false,
               'message' => 'Informations erronées',
           ]);
       }
       $prix = DB::table('tarification')->where('depart', $depart)->where('destination', $destination)->first();
       return response()->json([
           'success' => true,
           'data' => $prix
       ]);

    }
    public function get_solde_by_id_user( Request $request){
       
        $id_user = $request->id_user;
        if($id_user==""){
            return response()->json([
                'success' => false,
                'message' => 'Informations erronées',
            ]);
        }

        $solde=0;
        $tarif=0;

        $comptes = DB::table('compte_user')->where('id_user', $id_user);

        foreach ($comptes->get() as $compte) {
            $solde = $solde+$compte->montant;
        }


        return response()->json([
            'success' => true,
            'data' => $solde
        ]);

    }

    public function resa_desservi( Request $request){
       
        $statut = $request->statut;

        if($statut==""){
            return response()->json([
                'success' => false,
                'message' => 'Informations erronées',
            ]);
        }

        

        $reservations = DB::table('reservation')
            ->where('desservi', $statut)
            ->where('date_depart', '>=', Carbon::now())
            ->get();

        return response()->json([
            'success' => true,
            'data' => $reservations
        ]); 

    }

    public function search_car_available( Request $request){
       
        // id_cat="+id_cat+"&boite_vitesse="+boite_vitesse+"&carburant="+carburant+"&date_debut="+date_debut+"&date_fin="+date_fin
        
        $id_cat = $request->id_cat;
        $boite_vitesse = $request->boite_vitesse;
        $carburant = $request->carburant;
        $date_debut = $request->date_debut;
        $date_fin = $request->date_fin;

        if($id_cat=="" || $boite_vitesse=="" || $carburant=="" || $date_debut=="" || $date_fin==""){
            return response()->json([
                'success' => false,
                'message' => 'Informations erronées',
            ]);
        }

        
        if ($boite_vitesse!="tous") {

            if($carburant!="tous"){
                
                


            }else{

                $stmt = $pdo->prepare('SELECT * FROM voitures WHERE id_cat = :id_cat AND boite_vitesse=:boite_vitesse');
                $stmt->execute(['id_cat' =>$id_cat,'boite_vitesse' =>$boite_vitesse]);
            }
            
        }else{
            if($carburant!="tous"){
                $stmt = $pdo->prepare('SELECT * FROM voitures WHERE id_cat = :id_cat AND carburant=:carburant');
                $stmt->execute(['id_cat' =>$id_cat,'carburant' =>$carburant]);
            }else{

                $stmt = $pdo->prepare('SELECT * FROM voitures WHERE id_cat = :id_cat');
                $stmt->execute(['id_cat' =>$id_cat]);
            }
        }

    }

}
